﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace HIPS.Web.Components.Web
{

    /// <summary>
    /// Represents a minimal implementation of an HttpContext.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="15 January 2014">Initial version.</change>
    /// </history>
    [Serializable]
    public class FakeHttpContext : HttpContextBase
    {

        #region Private Members
        private HttpRequestBase mRequest;
        #endregion

        #region Properties

        /// <summary>
        /// Gets the HttpRequest associated with this HttpContext.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="15 January 2014">Initial version.</change>
        /// </history>
        public override HttpRequestBase Request
        {
            get
            {
                return this.mRequest;
            }
        }

        #endregion

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="request"></param>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="15 January 2014">Initial version.</change>
        /// </history>
        public FakeHttpContext(HttpRequestBase request)
        {
            this.mRequest = request;
        }

        #endregion

    }

    /// <summary>
    /// Represents a minimal implementation of an HttpRequest.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="15 January 2014">Initial version.</change>
    /// </history>
    [Serializable]
    public class FakeHttpRequest : HttpRequestBase
    {

        #region Private Members
        private string mAppRelativeCurrentExecutionFilePath;
        private string mPathInfo;
        #endregion

        #region Properties

        /// <summary>
        /// Gets the AppRelativeCurrentExecutionFilePath.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="15 January 2014">Initial version.</change>
        /// </history>
        public override string AppRelativeCurrentExecutionFilePath
        {
            get
            {
                return this.mAppRelativeCurrentExecutionFilePath;
            }

        }

        /// <summary>
        /// Gets the PathInfo.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="15 January 2014">Initial version.</change>
        /// </history>
        public override string PathInfo
        {
            get
            {
                return this.mPathInfo;
            }
        }

        #endregion

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="appRelativeCurrentExecutionFilePath"></param>
        /// <param name="pathInfo"></param>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="15 January 2014">Initial version.</change>
        /// </history>
        public FakeHttpRequest(string appRelativeCurrentExecutionFilePath, string pathInfo)
        {
            this.mAppRelativeCurrentExecutionFilePath = appRelativeCurrentExecutionFilePath;
            this.mPathInfo = pathInfo;
        }

        #endregion

    }




}
